import process_results
import end_of_training_hpo
import sys


def turn_str_into_arg(str_dict):
    out = {}
    for arg in str_dict:
        out["--"+arg] = str_dict[arg]
    return out


if __name__ == '__main__':
    for i, arg in enumerate(sys.argv):
        if arg == "--model":
            method = sys.argv[i+1]
            break
    sys.argv += ['--nowand', '1']
    val_results = process_results.get_results("results/fixed_val")
    per_task_hpo_settings = process_results.get_best_per_task_settings_with_acc(val_results, setting='class-il')
    for dataset in per_task_hpo_settings[method]:
        args = ["--dataset", dataset]
        args += ['--log_dir', 'results/first_task/']
        if method == "esmer":
            per_task_hpo_settings[method][dataset][0][0]["loss_margin"] = per_task_hpo_settings[method][dataset][0][0]["beta"]
            del per_task_hpo_settings[method][dataset][0][0]["beta"]
        print("HP setting used: "+str(per_task_hpo_settings[method][dataset][0][0]))
        end_of_training_hpo.run_exp(turn_str_into_arg(per_task_hpo_settings[method][dataset][0][0]), base_args=sys.argv+args)

